<?php
require_once "../db/database.php";

// Pārbauda, vai ir iegūts grāmatas id
if(isset($_GET['id'])) {
    // Ja ir iegūts, tad do definē kā grāmatas id
    $bookId = $_GET['id'];

    // Pieprasījums, kas iegūst visas grāmatas pēc id
    $query = "SELECT * FROM books WHERE id = ?";
    $statement = $mysqli->prepare($query);
    $statement->bind_param("i", $bookId); 
    $statement->execute();
    $result = $statement->get_result();

    // Ja ir iegūtas grāmatas, tad izveido grāmatas logu
    if($result->num_rows > 0) {
        $book = $result->fetch_assoc();
        // Izveido HTML struktūru grāmatas logam
        echo '<div class="popup-book-info">';
        echo '<div class="popup-book-image">';
        echo '<img id="popup-book-image" src="../uploads/' . $book['image'] . '" alt="">';
        echo '</div>';
        echo '<div class="popup-book-details">';
        echo '<h2 id="popup-book-title">' . $book['title'] . '</h2>';
        echo '<p id="popup-book-description">' . 'Autors: ' . $book['author'] 
                                               . '<br>'
                                               . 'Gads: ' . $book['year'] 
                                               . '<br>' 
                                               . '<br>'
                                               . $book['description'] . '</p>';
        echo '</div>';
        echo '</div>';
        echo '</div>';
    } else {
        // Ja nav iegūtas grāmatas, izvada kļūdas ziņojumu
        echo '<div class="popup-content">';
        echo '<p class="error-message">Grāmata nav atrasta</p>';
    }
} else {
    //Ja nav iegūts grāmatas id, izvada kļūdas ziņojumu
    echo '<div class="popup-content">';
    echo '<p class="error-message">Grāmatas id nav saņemts</p>';
    echo '</div>';
}